/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import morph.avaritia.api.ExtremeCraftingRecipe;
import morph.avaritia.compat.jei.AvaritiaJEIPlugin;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.recipe.ExtremeShapedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExtremeRecipeCategory
implements IRecipeCategory<ExtremeCraftingRecipe> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("avaritia", "textures/gui/extreme_crafting_jei.png");
    private static final Component TITLE = new TranslatableComponent("avaritia:container.extreme_crafting.title");
    private final IDrawable background;
    private final IDrawable icon;

    public ExtremeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 0, 189, 163);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AvaritiaModContent.EXTREME_CRAFTING_TABLE_ITEM.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ExtremeCraftingRecipe recipe, IFocusGroup focuses) {
        List<List> inputs = recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        ItemStack resultItem = recipe.m_8043_();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 168, 74).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(resultItem));
        ArrayList<IRecipeSlotBuilder> inputSlots = new ArrayList<IRecipeSlotBuilder>(81);
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                inputSlots.add(builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 2, y * 18 + 2));
            }
        }
        if (recipe instanceof ExtremeShapedRecipe) {
            ExtremeShapedRecipe r = (ExtremeShapedRecipe)recipe;
            for (int w = 0; w < r.getWidth(); ++w) {
                for (int h = 0; h < r.getHeight(); ++h) {
                    int idx = w + h * 9;
                    int idx2 = w + h * r.getWidth();
                    ((IRecipeSlotBuilder)inputSlots.get(idx)).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs.get(idx2));
                }
            }
        } else {
            builder.setShapeless();
            for (int i = 0; i < inputs.size(); ++i) {
                ((IRecipeSlotBuilder)inputSlots.get(i)).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputs.get(i));
            }
        }
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends ExtremeCraftingRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<ExtremeCraftingRecipe> getRecipeType() {
        return AvaritiaJEIPlugin.EXTREME_CRAFTING_TYPE;
    }
}

